/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.localization.Language;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.settings.ModeSetting;
import Krasnodar.rockstarnew.systems.theme.Theme;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;

@ModuleInfo(name="Interface", category=ModuleCategory.VISUALS, enabledByDefault=true)
public class Interface
extends BaseModule {
    private final ModeSetting mode = new ModeSetting(this, "modules.settings.interface.mode");
    private final ModeSetting.Value liquidGlass = new ModeSetting.Value(this.mode, "modules.settings.interface.liquidGlass");
    private final ModeSetting.Value minimalism = new ModeSetting.Value(this.mode, "modules.settings.interface.minimalism");
    private final ModeSetting themeMode = new ModeSetting((SettingsContainer)this, "modules.settings.interface.theme", this.liquidGlass::isSelected);
    public final ModeSetting.Value dark = new ModeSetting.Value(this.themeMode, "modules.settings.interface.dark");
    public final ModeSetting.Value light = new ModeSetting.Value(this.themeMode, "modules.settings.interface.light");
    private final ModeSetting language = new ModeSetting(this, "modules.settings.interface.language");
    private final Animation liquidGlassAnim = new Animation(500L, Easing.BOTH_CUBIC);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean languageAutoDetected;
    private int lastLang = 0;
    private final EventListener<HudRenderEvent> onHudRenderEvent = event -> {
        this.liquidGlassAnim.setEasing(Easing.FIGMA_EASE_IN_OUT);
        this.liquidGlassAnim.update(this.liquidGlass.isSelected());
        int lang = this.language.getValues().indexOf(this.language.getValue());
        if (lang != this.lastLang) {
            Localizator.setLanguage(lang == 0 ? Language.RU_RU : (lang == 1 ? Language.EN_US : (lang == 2 ? Language.UK_UA : Language.PL_PL)));
            this.languageAutoDetected = false;
        }
        this.lastLang = lang;
        Rockstar.getInstance().getThemeManager().setCurrentTheme(this.dark.isSelected() ? Theme.DARK : Theme.LIGHT);
    };

    public Interface() {
        new ModeSetting.Value(this.language, "\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        new ModeSetting.Value(this.language, "English");
        new ModeSetting.Value(this.language, "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430");
        new ModeSetting.Value(this.language, "polski");
    }

    private void detectLanguageByIP() {
        this.executor.submit(() -> {
            try {
                String countryCode = this.getCountryCodeByIP();
                if (countryCode != null) {
                    String var2;
                    switch (var2 = countryCode.toUpperCase()) {
                        case "UA": {
                            this.language.setValue(this.language.getValues().get(2));
                            Localizator.setLanguage(Language.UK_UA);
                            break;
                        }
                        case "PL": {
                            this.language.setValue(this.language.getValues().get(3));
                            Localizator.setLanguage(Language.PL_PL);
                            break;
                        }
                        default: {
                            this.language.setValue(this.language.getValues().getFirst());
                            Localizator.setLanguage(Language.RU_RU);
                        }
                    }
                    this.languageAutoDetected = true;
                    this.lastLang = this.language.getValues().indexOf(this.language.getValue());
                }
            }
            catch (Exception var4) {
                Rockstar.LOGGER.error("Failed to detect language by IP", (Throwable)var4);
            }
        });
    }

    private String getCountryCodeByIP() throws IOException {
        URL url = new URL("http://ip-api.com/json/?fields=countryCode");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String json = response.toString();
            int start = json.indexOf("countryCode\":\"") + 14;
            if (start >= 14) {
                int end = json.indexOf("\"", start);
                String string = json.substring(start, end);
                return string;
            }
        }
        return null;
    }

    public static boolean glassSelected() {
        return Rockstar.getInstance().getModuleManager().getModule(Interface.class).liquidGlass.isSelected();
    }

    public static float glass() {
        return Rockstar.getInstance().getModuleManager().getModule(Interface.class).liquidGlassAnim.getValue();
    }

    public static float minimalizm() {
        return 1.0f - Interface.glass();
    }

    public static boolean showGlass() {
        return Interface.glass() > 0.0f;
    }

    public static boolean showMinimalizm() {
        return Interface.glass() < 1.0f;
    }

    @Generated
    public ModeSetting getMode() {
        return this.mode;
    }

    @Generated
    public ModeSetting.Value getLiquidGlass() {
        return this.liquidGlass;
    }

    @Generated
    public ModeSetting.Value getMinimalism() {
        return this.minimalism;
    }

    @Generated
    public ModeSetting getThemeMode() {
        return this.themeMode;
    }

    @Generated
    public ModeSetting.Value getDark() {
        return this.dark;
    }

    @Generated
    public ModeSetting.Value getLight() {
        return this.light;
    }

    @Generated
    public ModeSetting getLanguage() {
        return this.language;
    }

    @Generated
    public Animation getLiquidGlassAnim() {
        return this.liquidGlassAnim;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public boolean isLanguageAutoDetected() {
        return this.languageAutoDetected;
    }

    @Generated
    public int getLastLang() {
        return this.lastLang;
    }

    @Generated
    public EventListener<HudRenderEvent> getOnHudRenderEvent() {
        return this.onHudRenderEvent;
    }
}

